function [q1,q2] = compute_quantiles(n)

% It computes the quantiles of order .025 and .975 for the statistical
% method woth tracks of length n

alpha = .05;
N=1000001;
R=zeros(1,N);
S=R;
sigma=R;

normcol = @(X) sqrt(sum(X.^2,1));
normcol2 = @(X) sum(sum(X.^2,1));

for i=1:N
    X=zeros(2,n+1);
    for j=2:n+1
        epsilon = mvnrnd([0,0], [1,0;0,1])';
        X(:,j)=X(:,j-1)+epsilon./sqrt(n);
    end
    S(i) = max(normcol(X));
    sigma(i) = sqrt(normcol2(X(:,2:end)-X(:,1:end-1))/2); 
    R(i) = S(i)/sigma(i);
end

R= sort(R);

q1= R(floor(N*alpha/2));
q2= R(floor(N*(1-alpha/2)));



end

